/**
* Script: radlib.js
* Written by: Radnen
* Updated: 11/18/2010
**/

// screen constants:
const SH = GetScreenHeight();
const SW = GetScreenWidth();
const SW2 = SW / 2;
const SH2 = SH / 2;

// Math constants:
const PI = Math.PI;

/**
* RadLib general game library.
*  - Used for the Sphere Game Engine version 1.5 and up.
* 
*  - Head to: "http://www.spheredev.org" for the Sphere engine.
* 
*  - The radlib general game library allows you to create any game
*    from grounds up, without a focus for genre or style. By giving
*    you access to essentials like an audio manager or game state
*    manager, you can create whatever it is you want with all of the
*    unspecific code written for you. Therefore giving you a substantial
*    decrease in total game creation time.
*
*  - To use in your own game, simply: RequireScript("RadLib/RadLib.js");
*
*  - There has also been packages written for it:
*    - RadGui: handles GUI related material, using the game state object.
*    - RadRpg: handles RPG specific code like shops, items, and what-not.
*    - RadAct: handles action games - TBA.
*    - RadPlat: handles platformers - TBA. (either w/ RadLib or RadAct).
*    - RadPuzz: handles puzzle games - TBD.
**/

/**
* These are all of the phyisics based scripts:
**/
RequireScript("RadLib/physics/angle.js");
RequireScript("RadLib/physics/physics.js");
RequireScript("RadLib/physics/vector.js");

/**
* These are all of the general game scripts:
**/
RequireScript("RadLib/animate.js");
RequireScript("RadLib/timedvalue.js");
RequireScript("RadLib/audio.js");
RequireScript("RadLib/resources.js");
RequireScript("RadLib/camera.js");
RequireScript("RadLib/color.js");
RequireScript("RadLib/cursor.js");
RequireScript("RadLib/event.js");
RequireScript("RadLib/game.js");
RequireScript("RadLib/image.js");
RequireScript("RadLib/pathing.js");
RequireScript("RadLib/screen.js");
RequireScript("RadLib/state.js");
RequireScript("RadLib/updater.js");
RequireScript("RadLib/utility.js");

/**
* Old scripts added for backwards compatibility:
**/

RequireScript("RadLib/old_dynaimage.js");
RequireScript("RadLib/old_radmove.js");

/**
* These are scripts not written by me:
**/
RequireScript("RadLib/other/clock.js");
RequireScript("RadLib/other/json2.js");
RequireScript("RadLib/other/minimap.js");